<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

/*
This page just has links to some helpful resources for AdLogger.
It links back to AdLogger Documentation.
*/

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure that the person is logged in.
require ("./loginverify.php");

/*
Include the functions. Start the page timer, output the opening HTML,
and verify that we can actually connect to the database.
*/
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('support', $version_num);
	bodyNavigation('support');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);
?>
<div id="side-bar">
	<div>
		<p class="sideBarTitle">Support</p>
			<ul>
				<li><a href="http://www.adlogger.org/index.php/Documentation" target="_blank">&rsaquo; Documentation</a></li>
				<li><a href="http://www.adlogger.org/forum/" target="_blank">&rsaquo; Forum</a></li>
				<li><a href="http://www.adlogger.org/index.php/Donate" target="_blank">&rsaquo; Donations</a></li>
			</ul>
	</div>
</div>

<div id="main-copy">
	<h1 id="documentation">Documentation</h1>
	<p>Documentation can be found at <a href="http://www.adlogger.org/index.php/Documentation">AdLogger Documentation</a>.</p>
	<p>Nearly all aspects of the site should be well documented and covered in depth. Please read the manual before using AdLogger.</p>

	<h1 id="forum">Forum</h1>
	<p>The best place to get support regarding AdLogger can be found at the forums, at <a href="http://www.adlogger.org/forum/" target="_blank">AdLogger Forum</a></p>
	<p>The forum is a fairly active place with many knowledgeable programmers. Your question should get answered fairly quickly.</p>
	<p>Register for and check out the <a href="http://www.adlogger.org/forum/" target="_blank">Forums</a>!</p>

	<h1 id="donations">Donations</h1>
	<p>If you would like to contribute to the AdLogger project, please consider making a donation. It is because of your continued donations that AdLogger is offered as free and open source software.</p>
	<p>To donate, please visit <a href="http://www.adlogger.org/index.php/Donate" target="_blank">AdLogger Donations</a>.</p>

</div>

<?php
// Output the closing HTML for the footer.
bodyFooter('support', $start_time);
?>